IF EXISTS ( SELECT * FROM SYS.PROCEDURES WHERE NAME = 'P_CONSULTA_PRODUTO_EQUIV_PRECO_LIQ' )
BEGIN
	DROP PROCEDURE P_CONSULTA_PRODUTO_EQUIV_PRECO_LIQ
END
GO


CREATE PROCEDURE P_CONSULTA_PRODUTO_EQUIV_PRECO_LIQ
(	@CD_EMP INT
	, @CD_FILIAL INT
	, @CD_PROD  INT
	, @MESMA_APRES  BIT			-- MESMA PRES  ???   USA CD_APRES NO JOIN EST_PROD_EST_ARV_MERCADOLOGICA
	, @CD_CONV  INT   
	, @NR_CARTAO_FIDEL VARCHAR( 50 )  
	, @EAN  INT  
	, @CD_CLI  INT    
	, @QTDE_PROD  INT 
	, @APPLICATION  INT  
	, @ID_PROMO INT
	, @IS_RECEITA  INT
	, @CD_FRM_PGTO  INT
	, @CD_VEND  INT
	, @CD_PARCEIRO  INT
	, @TP_ORIG_VENDA  INT
	, @USA_DESCONTO_PROPZ_IDENT INT = 0
)


AS


/*

EXEC P_CONSULTA_PRODUTO_EQUIV_PRECO_LIQ  1 , 18 , 137448 , 0 , 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
EXEC P_CONSULTA_PRODUTO_EQUIV_PRECO_LIQ  1 , 18 , 137448 , 1 , 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
EXEC P_CONSULTA_PRODUTO_EQUIV_PRECO_LIQ  1 , 18 , 80584 , 0 , 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
80584

*/


SET NOCOUNT OFF

DECLARE @VAR_CD_PROD  INT


DECLARE @TEMP_CODS_PRODUTO TABLE 
   ( CD_PROD INT )
	
DECLARE @TEMP_RS_PRODUTO_POOL TABLE
   (
		VERSAO VARCHAR(100)
		,CD_EMP INT
		,CD_FILIAL INT
		,CD_PROD INT
		,DS_PROD VARCHAR(100)
		,NM_FABRIC VARCHAR(100)
		,VLR_TABELA MONEY
		,VLR_OFERTA MONEY
		,QTDE_PONTO_FIDEL MONEY
		,CTR_PMC INT
		,LIB_DESC_VERBA INT
		,FLAG_REQUER_RECEIT INT
		,FLAG_ALTERAR_PRECO INT
		,PROD_USO_CONT INT
		,TP_PROD INT
		,VLR_CUSTO MONEY
		,CD_GRP INT
		,QTD_PONTO_VENDA MONEY
		,LMT_PROD_PONTO_VENDA MONEY
		,APRES_QT_VD INT
		,QTDE_ESTOQUE MONEY
		,DS_TIPO_RECEITA VARCHAR(100)
		,DS_COR_RECEITA VARCHAR(100)
		,PERC_DESC_LIMITE MONEY
		,CD_TRIB_FC VARCHAR(3)
		,PERC_ICMS_N_CONT_ESTA MONEY
		,PERC_RED_VD MONEY
		,LIBERA_VD_CONV INT
		,QTDE_PROD_MAX_CONV INT
		,FIXA_DESCONTO INT
		,TP_DESCONTO INT
		,VLR_ECONOMIA MONEY
		,DS_DESCONTO VARCHAR(150)
		,CD_TBL_DESC INT
		,TP_NIVEL INT
		,PERC_DESC MONEY
		,MAIOR_PERC_DESC MONEY
		,PRODUTO_CONTROLADO INT
		,VLR_PMC MONEY	
-- AVALIAR COLUNAS ABAIXO
		,FLAG_DESCONTO_TICKET_BLQ INT
		,PERC_DESC_FIDEL_MAX MONEY
		,PROMO_INDUSTRIA INT
		,PERC_DESC_ANIVER MONEY
		,PERC_DESC_CLAS MONEY
		,VLR_DESC_FABRIC MONEY
		,CAMPANHA INT
		,QTDE_PROD_CAMPANHA INT
		,FLAG_BLOQUEIA_DESCONTO INT
		,PERC_DESC_POS_PBM DECIMAL(6, 4)
		,CD_FAMILIA INT
		,NCM_PROD VARCHAR(50)
		,NR_REG_MS VARCHAR(150)
		,TP_TBL_DESC  INT DEFAULT ( 3 )
		,QTDE_LIMITE_VENDA_FAMILIA INT
		,DS_FAMILIA VARCHAR(255)
		,PERC_PIS MONEY
		,PERC_COFINS MONEY
		)



IF ISNULL( ( SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'FLAG_TIPO_PESQUISA_EQUIVALENCIA' ) ,  0 ) = 0  
BEGIN 

INSERT INTO @TEMP_CODS_PRODUTO
--DECLARE @CD_EMP INT = 1 , @CD_FILIAL INT = 18 , @CD_PROD  INT = 137448
SELECT 
		PROD.CD_PROD
	FROM EST_PROD AS PROD 
	JOIN EST_PROD_PRINC_ATIVOS_EST_PROD AS PRIN_ATIVO_RET 
		ON PROD.CD_EMP = PRIN_ATIVO_RET.CD_EMP
		AND PROD.CD_PROD = PRIN_ATIVO_RET.CD_PROD 
	JOIN EST_PROD_PRINC_ATIVOS AS PRIN_ATIVO 
		ON PRIN_ATIVO_RET.CD_PRINC_ATIVOS = PRIN_ATIVO.CD_PRINC_ATIVOS 
	JOIN EST_PROD_PRINC_ATIVOS_EST_PROD AS PRIN_ATIVO_PROD_CONS 
		ON PRIN_ATIVO.CD_PRINC_ATIVOS = PRIN_ATIVO_PROD_CONS.CD_PRINC_ATIVOS 
		AND PRIN_ATIVO_PROD_CONS.CD_PROD <> PRIN_ATIVO_RET.CD_PROD 
	JOIN EST_PROD_CPL AS PROD_CPL 
		ON PROD.CD_EMP = PROD_CPL.CD_EMP
		AND PROD.CD_PROD = PROD_CPL.CD_PROD 
	JOIN EST_PROD_PRECO AS PRECO 
		ON PROD_CPL.CD_EMP = PRECO.CD_EMP 
		AND PROD_CPL.CD_FILIAL = PRECO.CD_FILIAL 
		AND PROD_CPL.CD_PROD = PRECO.CD_PROD 
	JOIN EST_PROD_FABRIC AS PROD_FABRIC 
		ON PROD.CD_FABRIC = PROD_FABRIC.CD_FABRIC 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS PROD_ARV_MERC 
		ON PROD.CD_EMP = PROD_ARV_MERC.CD_EMP  
		AND PROD.CD_PROD = PROD_ARV_MERC.CD_PROD 
	JOIN EST_ARV_MERC_LINHA 
		ON PROD_ARV_MERC.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA 
		AND PROD_ARV_MERC.CD_EMP = EST_ARV_MERC_LINHA.CD_EMP  
	WHERE PRIN_ATIVO_PROD_CONS.CD_PROD = @CD_PROD 
		AND PROD_CPL.CD_FILIAL = @CD_FILIAL
		AND PROD.CD_EMP = @CD_EMP
		AND PROD.STS_PROD IN ( 0 , 2 )
		AND PROD_CPL.TP_PROD IN (0,9,10,11)
		AND PROD.STS_PROD_CALL_CENTER = 0

END ELSE
BEGIN

INSERT INTO @TEMP_CODS_PRODUTO
SELECT 
		EP_RETORNO.CD_PROD
	FROM EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_RETORNO 
	JOIN EST_PROD AS EP_RETORNO ON EPEAM_RETORNO.CD_EMP = EP_RETORNO.CD_EMP AND EPEAM_RETORNO.CD_PROD = EP_RETORNO.CD_PROD 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_CONS 
		ON EPEAM_RETORNO.CD_EMP = EPEAM_CONS.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EPEAM_CONS.CD_ARV_MERC_EQUI 
		AND ( @MESMA_APRES = 0 OR ( @MESMA_APRES = 1 AND  EPEAM_RETORNO.CD_APRES = EPEAM_CONS.CD_APRES  ) )
	JOIN EST_PROD AS EP_CONS 
		ON EPEAM_CONS.CD_EMP = EP_CONS.CD_EMP 
		AND EPEAM_CONS.CD_PROD = EP_CONS.CD_PROD  
		AND EPEAM_CONS.CD_APRES > 0
		AND EPEAM_CONS.CD_ARV_MERC_EQUI > 0 
		AND EP_RETORNO.CD_PROD <> EP_CONS.CD_PROD 
	JOIN EST_PROD_CPL AS EPL 
		ON EP_RETORNO.CD_EMP = EPL.CD_EMP 
		AND EP_RETORNO.CD_PROD = EPL.CD_PROD 
	JOIN EST_PROD_PRECO AS EPP 
		ON EPL.CD_EMP = EPP.CD_EMP 
		AND EPL.CD_FILIAL = EPP.CD_FILIAL 
		AND EPL.CD_PROD = EPP.CD_PROD 
	JOIN EST_ARV_MERC_EQUIVALENTE AS EAME 
		ON EPEAM_RETORNO.CD_EMP = EAME.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EAME.CD_ARV_MERC_EQUI 
	JOIN EST_ARV_MERC_APRESENTACAO AS EAMA 
		ON EPEAM_RETORNO.CD_EMP = EAMA.CD_EMP 
		AND EPEAM_RETORNO.CD_APRES = EAMA.CD_APRES 
	JOIN EST_PROD_FABRIC AS EPF 
		ON EP_RETORNO.CD_FABRIC = EPF.CD_FABRIC 
	JOIN EST_ARV_MERC_LINHA AS EAML 
		ON EPEAM_RETORNO.CD_EMP = EAML.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_LINHA = EAML.CD_ARV_MERC_LINHA 
	WHERE EPL.CD_FILIAL = @CD_FILIAL AND EP_CONS.CD_PROD = @CD_PROD   
		AND EP_RETORNO.CD_EMP = 1
		AND EP_RETORNO.STS_PROD IN ( 0 , 2 )
		AND EPL.TP_PROD IN (0,9,10,11)
		AND EP_RETORNO.STS_PROD_CALL_CENTER = 0

END


WHILE EXISTS (  SELECT TOP 1 1 FROM @TEMP_CODS_PRODUTO ORDER BY CD_PROD )  
BEGIN

   SET @VAR_CD_PROD = (SELECT TOP 1 CD_PROD FROM @TEMP_CODS_PRODUTO ORDER BY CD_PROD )

   INSERT INTO @TEMP_RS_PRODUTO_POOL
   EXEC P_EST_PROD_DESCONTOS
		@CD_EMP  = @CD_EMP
		, @CD_FILIAL  = @CD_FILIAL
		, @CD_PROD   = @VAR_CD_PROD
		, @CD_CONV   = @CD_CONV
		, @NR_CARTAO_FIDEL = @NR_CARTAO_FIDEL
		, @EAN    = @EAN
		, @CD_CLI  = @CD_CLI
		, @QTDE_PROD    = @QTDE_PROD
		, @APPLICATION  = @APPLICATION
		, @ID_PROMO    = @ID_PROMO
		, @IS_RECEITA  =  @IS_RECEITA
		, @CD_FRM_PGTO  = @CD_FRM_PGTO
		, @IGNORED   = 0
		, @CD_VEND   = @CD_VEND
		, @CD_PARCEIRO  = @CD_PARCEIRO
		, @TP_ORIG_VENDA  = @TP_ORIG_VENDA
		, @USA_DESCONTO_PROPZ_IDENT = @USA_DESCONTO_PROPZ_IDENT		
   DELETE FROM @TEMP_CODS_PRODUTO
      WHERE CD_PROD = @VAR_CD_PROD

END


IF ISNULL( ( SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'FLAG_TIPO_PESQUISA_EQUIVALENCIA' ) ,  0 ) = 0  
BEGIN 


SELECT  DISTINCT
		PROD.CD_PROD, PROD.DS_PROD, PRECO.VLR_TABELA ,
		CONVERT( DECIMAL( 12 ,2 ) , COALESCE(PRECO.VLR_TABELA,0.00)
							- (COALESCE(PRECO.VLR_TABELA,0.00)*(T.PERC_DESC/100.00) ) ) AS VLR_LIQUIDO, 
		'' AS DS_APRES, PRIN_ATIVO.DS_PRINC_ATIVOS AS DS_ARV_MERC_EQUI, PROD_CPL.QT_EST, 
		PROD_FABRIC.NM_FABRIC, EST_ARV_MERC_LINHA.DS_SIGLA_LINHA             , 
		(SELECT CASE ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'CTR_CUSTO_SEMAFORO'),0) WHEN 0 THEN VLR_CUSTO ELSE VLR_CUSTO_MD END    
			FROM EST_PROD_CPL   
			WHERE CD_EMP = 1 
				AND CD_FILIAL = @CD_FILIAL  
				AND CD_PROD = PROD.CD_PROD) AS VLR_CUSTO 
		,T.PERC_ICMS_N_CONT_ESTA
		,T.PERC_RED_VD
		,T.PERC_PIS
		,T.PERC_COFINS
	FROM @TEMP_RS_PRODUTO_POOL  T	 
	JOIN EST_PROD AS PROD 
		ON PROD.CD_EMP  = T.CD_EMP
		AND PROD.CD_PROD = T.CD_PROD
	JOIN EST_PROD_PRINC_ATIVOS_EST_PROD AS PRIN_ATIVO_RET 
		ON PROD.CD_EMP = PRIN_ATIVO_RET.CD_EMP
		AND PROD.CD_PROD = PRIN_ATIVO_RET.CD_PROD 
	JOIN EST_PROD_PRINC_ATIVOS AS PRIN_ATIVO 
		ON PRIN_ATIVO_RET.CD_PRINC_ATIVOS = PRIN_ATIVO.CD_PRINC_ATIVOS 
	JOIN EST_PROD_CPL AS PROD_CPL 
		ON PROD.CD_EMP = PROD_CPL.CD_EMP
		AND T.CD_FILIAL = PROD_CPL.CD_FILIAL
		AND PROD.CD_PROD = PROD_CPL.CD_PROD 
	JOIN EST_PROD_PRECO AS PRECO 
		ON PROD_CPL.CD_EMP = PRECO.CD_EMP 
		AND PROD_CPL.CD_FILIAL = PRECO.CD_FILIAL 
		AND PROD_CPL.CD_PROD = PRECO.CD_PROD 
	JOIN EST_PROD_FABRIC AS PROD_FABRIC 
		ON PROD.CD_FABRIC = PROD_FABRIC.CD_FABRIC 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS PROD_ARV_MERC 
		ON PROD.CD_EMP = PROD_ARV_MERC.CD_EMP  
		AND PROD.CD_PROD = PROD_ARV_MERC.CD_PROD 
	JOIN EST_ARV_MERC_LINHA 
		ON PROD_ARV_MERC.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA 
		AND PROD_ARV_MERC.CD_EMP = EST_ARV_MERC_LINHA.CD_EMP  

END ELSE
BEGIN

SELECT DISTINCT
		EP_RETORNO.CD_PROD, EP_RETORNO.DS_PROD, EPP.VLR_TABELA, 
		CONVERT( DECIMAL( 12 ,2 ) , COALESCE(EPP.VLR_TABELA,0.00)
							- (COALESCE(EPP.VLR_TABELA,0.00)*(T.PERC_DESC/100.00) ) ) AS VLR_LIQUIDO,
		EAMA.DS_APRES, EAME.DS_ARV_MERC_EQUI, EPL.QT_EST, 
		EPF.NM_FABRIC, EAML.DS_SIGLA_LINHA             , 
		(SELECT CASE ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'CTR_CUSTO_SEMAFORO'),0) WHEN 0 THEN VLR_CUSTO ELSE VLR_CUSTO_MD END    
			FROM EST_PROD_CPL   
			WHERE CD_EMP = 1 
				AND CD_FILIAL = @CD_FILIAL  
				AND CD_PROD = EP_RETORNO.CD_PROD) AS VLR_CUSTO 
		,T.PERC_ICMS_N_CONT_ESTA
		,T.PERC_RED_VD
		,T.PERC_PIS
		,T.PERC_COFINS
	FROM @TEMP_RS_PRODUTO_POOL  T	 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_RETORNO 
		ON EPEAM_RETORNO.CD_EMP  = T.CD_EMP
		AND EPEAM_RETORNO.CD_PROD = T.CD_PROD
	JOIN EST_PROD AS EP_RETORNO 
		ON EPEAM_RETORNO.CD_EMP = EP_RETORNO.CD_EMP 
		AND EPEAM_RETORNO.CD_PROD = EP_RETORNO.CD_PROD 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_CONS 
		ON EPEAM_RETORNO.CD_EMP = EPEAM_CONS.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EPEAM_CONS.CD_ARV_MERC_EQUI 
		AND ( @MESMA_APRES = 0 OR ( @MESMA_APRES = 1 AND  EPEAM_RETORNO.CD_APRES = EPEAM_CONS.CD_APRES  ) )
	--JOIN EST_PROD AS EP_CONS 
	--	ON EPEAM_CONS.CD_EMP = EP_CONS.CD_EMP 
	--	AND EPEAM_CONS.CD_PROD = EP_CONS.CD_PROD  
	--	AND EPEAM_CONS.CD_APRES > 0
	--	AND EPEAM_CONS.CD_ARV_MERC_EQUI > 0 
	--	AND EP_RETORNO.CD_PROD <> EP_CONS.CD_PROD 
	JOIN EST_PROD_CPL AS EPL 
		ON EP_RETORNO.CD_EMP = EPL.CD_EMP 
		AND T.CD_FILIAL = EPL.CD_FILIAL
		AND EP_RETORNO.CD_PROD = EPL.CD_PROD 
	JOIN EST_PROD_PRECO AS EPP 
		ON EPL.CD_EMP = EPP.CD_EMP 
		AND EPL.CD_FILIAL = EPP.CD_FILIAL 
		AND EPL.CD_PROD = EPP.CD_PROD 
	JOIN EST_ARV_MERC_EQUIVALENTE AS EAME 
		ON EPEAM_RETORNO.CD_EMP = EAME.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EAME.CD_ARV_MERC_EQUI 
	JOIN EST_ARV_MERC_APRESENTACAO AS EAMA 
		ON EPEAM_RETORNO.CD_EMP = EAMA.CD_EMP 
		AND EPEAM_RETORNO.CD_APRES = EAMA.CD_APRES 
	JOIN EST_PROD_FABRIC AS EPF 
		ON EP_RETORNO.CD_FABRIC = EPF.CD_FABRIC 
	JOIN EST_ARV_MERC_LINHA AS EAML 
		ON EPEAM_RETORNO.CD_EMP = EAML.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_LINHA = EAML.CD_ARV_MERC_LINHA 

END


--FIM
GO